/*****************************************************************************
*  LPC54xx SCT PWM program for LPCXpresso board
*
*  1. Use SCT timer to generate a PWM output signal @ SCT0_OUT5
*  2. Every time P0_24 (sw1) goes high to low increase the duty cycle.
*  3. Every time P0_31  (sw2) goes high to low decrease the duty cycle.
*  4. SCT0_OUT5 is connected to P1_2 (green LED).
*****************************************************************************/

#include "board.h"

/*****************************************************************************
 * Private types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Public types/enumerations/variables
 ****************************************************************************/

/*****************************************************************************
 * Private functions
 ****************************************************************************/
void SCT_Init(void);
/*****************************************************************************
 * Public functions
 ****************************************************************************/

void SCT_Init(void)
{

	Chip_SCT_Init(LPC_SCT);			                   					// enable the SCT clock

	Chip_SCT_Config(LPC_SCT, SCT_CONFIG_16BIT_COUNTER	|	 				// two 16-bit timers
							  SCT_CONFIG_AUTOLIMIT_L	);					// auto limit


	Chip_SCT_SetControl(LPC_SCT, 	(SystemCoreClock/1000000-1) << 5);		// set prescaler, SCT clock = 1 MHz


	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_0,	9);						// match 0 @ 10/1MHz = 10 usec (100 KHz PWM freq)
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_0, 9);

	Chip_SCT_SetMatchCount(LPC_SCT, SCT_MATCH_1,	5);						// match 1 used for duty cycle (in 10 steps)
	Chip_SCT_SetMatchReload(LPC_SCT, SCT_MATCH_1, 5);


	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_0, ENABLE_ALL_STATES);			// event 0 happens in all states
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_0,  (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH0 |
                                                                          SCT_COMBMODE_MATCH ));		// match 0 condition only

	Chip_SCT_EventState(LPC_SCT, SCT_EVENT_1, ENABLE_ALL_STATES);			// event 1 happens in all states
	Chip_SCT_EventControl(LPC_SCT, SCT_EVENT_1,  (CHIP_SCT_EVENTCTRL_T) (  SCT_EVECTRL_MATCH1 |
                                                                          SCT_COMBMODE_MATCH ));		// match 1 condition only

	Chip_SCT_SetOutput(LPC_SCT, SCT_OUTPUT_5, SCT_EVT_0 );					// event 0 will set   SCT_OUT5
	Chip_SCT_ClearOutput(LPC_SCT, SCT_OUTPUT_5, SCT_EVT_1);				// event 1 will clear SCT_OUT5


    Chip_SCT_ClearControl(LPC_SCT, SCT_CTRL_HALT_L);		// start timer
}


int main(void)
{

	static uint8_t trgsw1 = 1;
	static uint8_t trgsw2 = 1;


  	SystemCoreClockUpdate();
  	Board_Init();


  	Chip_Clock_EnablePeriphClock( (CHIP_SYSCON_CLOCK_T)	( SYSCON_CLOCK_IOCON	|			//enable SWM clock
                                                          SYSCON_CLOCK_GPIO0	|			// enable clock to GPIO port 0 and 1
                                                          SYSCON_CLOCK_GPIO1	));

  	Chip_IOCON_PinMuxSet(LPC_IOCON, 1, 2, IOCON_FUNC3 | IOCON_MODE_INACT | IOCON_DIGITAL_EN | IOCON_INPFILT_OFF);		//SCT0_OUT5 = P1.2  (green   LED)

    SCT_Init();                                           									// Initialize SCT3

    while (1)                                              									// loop forever
    {
    	 if (!Chip_GPIO_GetPinState(LPC_GPIO, 0,24) && trgsw1)      						// P0_24 (sw1) high to low?
    	 {
    	     trgsw1 = 0;                                     								// trigger sw1 low
    	     if (LPC_SCT->MATCHREL[1].L < 20)
    	        LPC_SCT->MATCHREL[1].L ++;                 									// increase PWM dutycycle
    	 }
    	 else if (Chip_GPIO_GetPinState(LPC_GPIO, 0,24) && !trgsw1)  						// P0_24 (sw1) low to high?
    	 {
    	       trgsw1 = 1;                                        							// trigger sw1 high
    	 }

    	 if (!Chip_GPIO_GetPinState(LPC_GPIO, 0,31) && trgsw2)        						// P0_31 (sw2) high to low?
    	 {
    	       trgsw2 = 0;                                        							// trigger sw3 low
    	       if (LPC_SCT->MATCHREL[1].L > 0)
    	            LPC_SCT->MATCHREL[1].L --;												// decrease PWM dutycycle
    	 }
    	 else if (Chip_GPIO_GetPinState(LPC_GPIO, 0,31) && !trgsw2)   						// P0_31 (sw2) low to high?
    	 {
    	       trgsw2 = 1;                                        							// trigger sw3 high
    	 }
    }
}
